# Dropzone Action Info
# Name: Copy Files
# Description: Allows you to copy dropped files to a specified folder.
# Handles: Files
# Creator: Aptonic
# URL: https://aptonic.com
# OptionsNIB: ChooseFolder
# UseSelectedItemNameAndIcon: Yes
# SkipConfig: No
# RunsSandboxed: Yes
# Version: 1.0
# MinDropzoneVersion: 4.0

def dragged
  $dz.determinate(true)
  $dz.begin("Copying files...")
  Rsync.do_copy($items, ENV['EXTRA_PATH'], false)
  last_component = ENV['EXTRA_PATH'].split('/').last.gsub(/^(.{30,}?).*$/m,'\1...')
  
  $dz.finish("Click here to open the '#{last_component}' folder")
  $dz.url(false)
end

def clicked
  escaped_path = ENV['EXTRA_PATH'].gsub(/["`$\\]/){ |s| '\\' + s }
  system("open \"#{escaped_path}\"")
end
